<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 17.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
initializeDatabaseConnection();

// Alte Buchungen bereinigen (Älter als 90 Tage)
function cleanOldBookingHistory(PDO $pdo, int $days = 90): int
{
    // Stichtag berechnen
    $cutoffDate = date('Y-m-d H:i:s', strtotime("-{$days} days"));

    // Alte Einträge löschen
    $sql = "DELETE FROM BookingHistory WHERE Timestamp < :cutoffDate";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['cutoffDate' => $cutoffDate]);

    // Anzahl der gelöschten Einträge zurückgeben
    $rowsDeleted = $stmt->rowCount();

    // Wenn Einträge gelöscht wurden, Audit-Log-Eintrag hinzufügen
    if ($rowsDeleted > 0) {
        addAuditLog('System', 'Auditing', description: "{$rowsDeleted} Einträge wurden automatisch aus der Buchungshistorie entfernt.");
    }

    return $rowsDeleted;
}
cleanOldBookingHistory($pdo);

// Alte Protokolle bereinigen (Älter als 90 Tage)
function cleanOldAuditLogs(PDO $pdo, int $days = 90): int
{
    // Stichtag berechnen
    $cutoffDate = date('Y-m-d H:i:s', strtotime("-{$days} days"));

    // Alte Einträge löschen
    $sql = "DELETE FROM AuditLogs WHERE Timestamp < :cutoffDate";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['cutoffDate' => $cutoffDate]);

    // Anzahl der gelöschten Einträge zurückgeben
    $rowsDeleted = $stmt->rowCount();

    // Wenn Einträge gelöscht wurden, Audit-Log-Eintrag hinzufügen
    if ($rowsDeleted > 0) {
        addAuditLog('System', 'Auditing', description: "{$rowsDeleted} Einträge wurden automatisch aus den Protokollen entfernt.");
    }

    return $rowsDeleted;
}
cleanOldAuditLogs($pdo);

?>